<?php

namespace wcf\system\template\plugin;

use wcf\system\exception\SystemException;
use wcf\system\template\TemplateScriptingCompiler;

/**
 * Template compiler plugin which prepends a value to a template variable.
 *
 * Usage:
 *  {prepend var=name value="foo"}
 *
 * @author  Marcel Werk
 * @copyright   2001-2019 WoltLab GmbH
 * @license GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 */
class PrependCompilerTemplatePlugin implements ICompilerTemplatePlugin
{
    /**
     * @inheritDoc
     */
    public function executeStart($tagArgs, TemplateScriptingCompiler $compiler)
    {
        if (!isset($tagArgs['var'])) {
            throw new SystemException(
                $compiler::formatSyntaxError(
                    "missing 'var' argument in prepend tag",
                    $compiler->getCurrentIdentifier(),
                    $compiler->getCurrentLineNo()
                )
            );
        }
        if (!isset($tagArgs['value'])) {
            throw new SystemException(
                $compiler::formatSyntaxError(
                    "missing 'value' argument in prepend tag",
                    $compiler->getCurrentIdentifier(),
                    $compiler->getCurrentLineNo()
                )
            );
        }

        return "<?php \$this->prepend(" . $tagArgs['var'] . ", " . $tagArgs['value'] . "); ?>";
    }

    /**
     * @inheritDoc
     */
    public function executeEnd(TemplateScriptingCompiler $compiler)
    {
        throw new SystemException(
            $compiler::formatSyntaxError(
                "unknown tag {/prepend}",
                $compiler->getCurrentIdentifier(),
                $compiler->getCurrentLineNo()
            )
        );
    }
}
